/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.recipe.bargain;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import tictim.paraglider.utils.TooltipFactory;

public final class BargainPreview {
    private final List<Demand> demands;
    private final List<Offer> offers;

    public BargainPreview(List<Demand> demands, List<Offer> offers) {
        this.demands = demands;
        this.offers = offers;
    }

    public List<Demand> getDemands() {
        return this.demands;
    }

    public List<Offer> getOffers() {
        return this.offers;
    }

    public String toString() {
        return "BargainPreview{demands=" + this.demands.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + ", offers=" + this.offers.stream().map(it -> it.toString()).collect(Collectors.joining(", ")) + '}';
    }

    public static final class Offer {
        private final ItemStack preview;
        private final int quantity;
        @Nullable
        private final TooltipFactory tooltipFactory;

        public Offer(ItemStack preview, int quantity) {
            this(preview, quantity, null);
        }

        public Offer(ItemStack preview, int quantity, @Nullable TooltipFactory tooltipFactory) {
            this.preview = preview;
            this.quantity = quantity;
            this.tooltipFactory = tooltipFactory;
        }

        public ItemStack getPreview() {
            return this.preview;
        }

        public int getQuantity() {
            return this.quantity;
        }

        @Nullable
        public TooltipFactory getTooltipFactory() {
            return this.tooltipFactory;
        }

        public String toString() {
            return "OfferPreview{preview=" + this.preview + ", quantity=" + this.quantity + '}';
        }
    }

    public static final class Demand {
        private final ItemStack[] previewItems;
        private final int quantity;
        private final Counter counter;
        @Nullable
        private final TooltipFactory tooltipFactory;

        public Demand(ItemStack previewItem, int quantity, Counter counter) {
            this(previewItem, quantity, counter, null);
        }

        public Demand(ItemStack[] previewItems, int quantity, Counter counter) {
            this(previewItems, quantity, counter, null);
        }

        public Demand(ItemStack previewItem, int quantity, Counter counter, @Nullable TooltipFactory tooltipFactory) {
            this(new ItemStack[]{previewItem}, quantity, counter, tooltipFactory);
        }

        public Demand(ItemStack[] previewItems, int quantity, Counter counter, @Nullable TooltipFactory tooltipFactory) {
            this.previewItems = previewItems;
            this.quantity = quantity;
            this.counter = counter;
            this.tooltipFactory = tooltipFactory;
        }

        public ItemStack[] getPreviewItems() {
            return this.previewItems;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public Counter getCounter() {
            return this.counter;
        }

        @Nullable
        public TooltipFactory getTooltipFactory() {
            return this.tooltipFactory;
        }

        public String toString() {
            return "DemandPreview{previewItems=" + Arrays.toString(this.previewItems) + ", quantity=" + this.quantity + ", counter=" + this.counter + '}';
        }

        @FunctionalInterface
        public static interface Counter {
            public int count(PlayerEntity var1);
        }
    }
}

